/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.init;

import java.util.Locale;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.item.KeyboardItem;
import net.montoyo.wd.core.CraftComponent;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.item.ItemCraftComponent;
import net.montoyo.wd.item.ItemLaserPointer;
import net.montoyo.wd.item.ItemLinker;
import net.montoyo.wd.item.ItemMinePad2;
import net.montoyo.wd.item.ItemOwnershipThief;
import net.montoyo.wd.item.ItemScreenConfigurator;
import net.montoyo.wd.item.ItemUpgrade;

public class ItemInit {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"webdisplays");
    protected static final RegistryObject<Item>[] COMP_CRAFT_ITEMS = new RegistryObject[CraftComponent.values().length];
    protected static final RegistryObject<Item>[] UPGRADE_ITEMS = new RegistryObject[DefaultUpgrade.values().length];
    public static final RegistryObject<Item> CONFIGURATOR = ITEMS.register("screencfg", () -> new ItemScreenConfigurator(new Item.Properties()));
    public static final RegistryObject<Item> OWNERSHIP_THEIF = ITEMS.register("ownerthief", () -> new ItemOwnershipThief(new Item.Properties()));
    public static final RegistryObject<Item> LINKER = ITEMS.register("linker", () -> new ItemLinker(new Item.Properties()));
    public static final RegistryObject<Item> MINEPAD = ITEMS.register("minepad", () -> new ItemMinePad2(new Item.Properties()));
    public static final RegistryObject<Item> LASER_POINTER = ITEMS.register("laserpointer", () -> new ItemLaserPointer(new Item.Properties()));
    public static final RegistryObject<Item> SCREEN;
    public static final RegistryObject<Item> KEYBOARD;
    public static final RegistryObject<Item> REDSTONE_CONTROLLER;
    public static final RegistryObject<Item> REMOTE_CONTROLLER;
    public static final RegistryObject<Item> SERVER;

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
    }

    public static RegistryObject<Item> getComputerCraftItem(int index) {
        return COMP_CRAFT_ITEMS[index];
    }

    public static RegistryObject<Item> getUpgradeItem(int index) {
        return UPGRADE_ITEMS[index];
    }

    public static boolean isCompCraftItem(Item item) {
        for (RegistryObject<Item> itemRegistryObject : COMP_CRAFT_ITEMS) {
            if (item != itemRegistryObject.get()) continue;
            return true;
        }
        return false;
    }

    static {
        DefaultUpgrade[] defaultUpgrades = DefaultUpgrade.values();
        for (int i = 0; i < defaultUpgrades.length; ++i) {
            DefaultUpgrade upgrade = defaultUpgrades[i];
            ItemInit.UPGRADE_ITEMS[i] = ITEMS.register("upgrade_" + upgrade.name().toLowerCase(Locale.ROOT), () -> new ItemUpgrade(upgrade));
        }
        CraftComponent[] components = CraftComponent.values();
        for (int i = 0; i < components.length; ++i) {
            CraftComponent cc = components[i];
            ItemInit.COMP_CRAFT_ITEMS[i] = ITEMS.register("craftcomp_" + cc.name().toLowerCase(Locale.ROOT), () -> new ItemCraftComponent(new Item.Properties()));
        }
        SCREEN = ITEMS.register("screen", () -> new BlockItem((Block)BlockInit.blockScreen.get(), new Item.Properties().m_41491_((CreativeModeTab)WebDisplays.CREATIVE_TAB)));
        KEYBOARD = ITEMS.register("keyboard", () -> new KeyboardItem((Block)BlockInit.blockKeyBoard.get(), new Item.Properties().m_41491_((CreativeModeTab)WebDisplays.CREATIVE_TAB)));
        REDSTONE_CONTROLLER = ITEMS.register("redctrl", () -> new BlockItem((Block)BlockInit.blockRedControl.get(), new Item.Properties().m_41491_((CreativeModeTab)WebDisplays.CREATIVE_TAB)));
        REMOTE_CONTROLLER = ITEMS.register("rctrl", () -> new BlockItem((Block)BlockInit.blockRControl.get(), new Item.Properties().m_41491_((CreativeModeTab)WebDisplays.CREATIVE_TAB)));
        SERVER = ITEMS.register("server", () -> new BlockItem((Block)BlockInit.blockServer.get(), new Item.Properties().m_41491_((CreativeModeTab)WebDisplays.CREATIVE_TAB)));
    }
}

